(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3438,        106]*)
(*NotebookOutlinePosition[      4281,        133]*)
(*  CellTagsIndexPosition[      4237,        129]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 2.3 \( \(.2\)\(.\)\)\ *) \[IndentingNewLine]\(k[x_, 
          s_] := \ Exp[x\ s];\)\[IndentingNewLine] (*\ 
      Use\ Gauss - Legendre\ rule\ for\ n = 
        2\ on\ the\ interval\ \((0, 1)\); \ 
      gausspoints\ are\ taken\ from\ gauss1 . 
          nb\ *) \), "\[IndentingNewLine]", 
    \(\(x = {0.21132486540518713`, 
          0.7886751345948129`};\)\), "\[IndentingNewLine]", 
    \(\(s = {0.21132486540518713`, 
          0.7886751345948129`};\)\), "\[IndentingNewLine]", 
    \(matk = 
      Table[k[x[\([i]\)], \ s[\([j]\)]\ ], {i, 2}, \ {j, 2}]\)}], "Input"],

Cell[BoxData[
    \({{1.0456703873624213`, 1.181360412865646`}, {1.181360412865646`, 
        1.8626653911158395`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(d = {{1/2, \ 0}, \ {0, \ 1/2}};\)\), "\[IndentingNewLine]", 
    \(a = matk . d\)}], "Input"],

Cell[BoxData[
    \({{0.5228351936812107`, 0.590680206432823`}, {0.590680206432823`, 
        0.9313326955579198`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu] {{1, 0}, \ {0, 1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(\(0.5228351936812107`\)\(\[InvisibleSpace]\)\) - \[Mu], 
        0.590680206432823`}, {0.590680206432823`, \(\(0.9313326955579198`\)\(\
\[InvisibleSpace]\)\) - \[Mu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]]\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.10208741780409529`}, {\[Mu] \[Rule] 
          1.352080471435035`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Similarly\ for\ n = 4, \ 6, \ 8\ *) \)], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{513, 387},
WindowMargins->{{9, Automatic}, {Automatic, 21}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 608, 12, 139, "Input"],
Cell[2350, 65, 129, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2516, 72, 116, 2, 43, "Input"],
Cell[2635, 76, 129, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2801, 83, 111, 2, 43, "Input"],
Cell[2915, 87, 205, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3157, 95, 66, 1, 27, "Input"],
Cell[3226, 98, 119, 2, 26, "Output"]
}, Open  ]],
Cell[3360, 103, 74, 1, 27, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

